<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <meta http-equiv="X-UA-Compatible" content="ie=edge">
    <title><?php echo e(env('APP_NAME')); ?></title>
    <link rel="icon" href="/assets/img/favicon.png" type="image/x-icon">
    <link rel="stylesheet" href="/assets/css/style.css">
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/toastr.js/latest/toastr.min.css">
    <meta name="csrf_token" value="<?php echo e(csrf_token()); ?>"/>
    <?php echo \Livewire\Mechanisms\FrontendAssets\FrontendAssets::styles(); ?>

</head>
<body id="dark">
    <header class="dark-bb">
        <nav class="navbar navbar-expand-lg fixed-top">
            <a class="navbar-brand" href="/"><img src="/assets/img/logo-light.png" alt="logo"></a>
            <?php if(auth()->guard()->check()): ?>
            <div class="d-block d-md-none header-mobile-stats-inline">
                <?php
$__split = function ($name, $params = []) {
    return [$name, $params];
};
[$__name, $__params] = $__split('header-mobile-stats');

$__html = app('livewire')->mount($__name, $__params, 'lw-3403229391-0', $__slots ?? [], get_defined_vars());

echo $__html;

unset($__html);
unset($__name);
unset($__params);
unset($__split);
if (isset($__slots)) unset($__slots);
?>
            </div>
            <?php endif; ?>
            <button class="navbar-toggler" type="button" data-toggle="collapse" data-target="#headerMenu"
                aria-controls="headerMenu" aria-expanded="false" aria-label="Toggle navigation">
                <i class="icon ion-md-menu"></i>
            </button>

            <div class="collapse navbar-collapse" id="headerMenu">
                <ul class="navbar-nav mr-auto">
                </ul>
                <ul class="navbar-nav ml-auto">
                    
                    <?php if(auth()->guard()->check()): ?>
                    <li class="nav-item dropdown">
                        <a class="nav-link" href="#" id="disabledIconsDropdown" role="button" data-toggle="dropdown" aria-haspopup="true" aria-expanded="false">
                            <img src="/assets/img/icon/menu.png" alt="Menu" width="28" height="28">
                        </a>
                        <div class="dropdown-menu p-4" aria-labelledby="disabledIconsDropdown" style="min-width:300px; right: 8px;">
                            <div class="row">
                                <div class="col-md-6 p-3">
                                <div class="text-center m-2" style="cursor: not-allowed;">
                                    <img src="/assets/img/icon/staking.png" class="img-fluid mb-3" alt="Staking" width="40" height="40" style="filter: grayscale(1) opacity(0.5); cursor: not-allowed;">
                                    <div style="color: #aaa; font-size: 14px;">Staking</div>
                                </div>
                                </div>
                                <div class="col-md-6 p-3">
                                <div class="text-center m-2" style="cursor: not-allowed;">
                                    <img src="/assets/img/icon/copy-trading.png" class="img-fluid mb-3" alt="Copy Trading" width="40" height="40" style="filter: grayscale(1) opacity(0.5); cursor: not-allowed;">
                                    <div style="color: #aaa; font-size: 14px;">Copy Trading</div>
                                </div>
                                </div>
                                <div class="col-md-6 p-3">
                                    <div class="text-center m-2" style="cursor: not-allowed;">
                                        <img src="/assets/img/icon/portfolio.png" class="img-fluid mb-3" alt="Portfolio" width="40" height="40" style="filter: grayscale(1) opacity(0.5); cursor: not-allowed;">
                                        <div style="color: #aaa; font-size: 14px;">Portfolio</div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </li>
                    
                    <li class="nav-item mt-1">
                        <a class="nav-link btn btn-secondary" href="<?php echo e(route('wallet')); ?>">Wallet</a>
                    </li>
                    <?php if(Auth::user()->hasRole('admin')): ?>
                        <li class="nav-item mt-1">
                            <a class="nav-link" href="<?php echo e(route('admin.dashboard')); ?>">Admin</a>
                        </li>
                    <?php elseif(Auth::user()->hasRole('manager')): ?>
                        <li class="nav-item mt-1">
                            <a class="nav-link" href="<?php echo e(route('admin.dashboard')); ?>">CRM</a>
                        </li>
                    <?php endif; ?>
                    <li class="nav-item dropdown header-img-icon">
                        <a class="nav-link dropdown-toggle" href="#" role="button" data-toggle="dropdown" aria-haspopup="true"
                            aria-expanded="false">
                            <img src="/assets/img/icon/profile.png" alt="avatar">
                        </a>
                        <?php if (isset($component)) { $__componentOriginalc7e006f324f287080794af0ddf69bd8d = $component; } ?>
<?php if (isset($attributes)) { $__attributesOriginalc7e006f324f287080794af0ddf69bd8d = $attributes; } ?>
<?php $component = App\View\Components\UserDropdown::resolve([] + (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag ? (array) $attributes->getIterator() : [])); ?>
<?php $component->withName('user-dropdown'); ?>
<?php if ($component->shouldRender()): ?>
<?php $__env->startComponent($component->resolveView(), $component->data()); ?>
<?php if (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag && $constructor = (new ReflectionClass(App\View\Components\UserDropdown::class))->getConstructor()): ?>
<?php $attributes = $attributes->except(collect($constructor->getParameters())->map->getName()->all()); ?>
<?php endif; ?>
<?php $component->withAttributes([]); ?>
<?php echo $__env->renderComponent(); ?>
<?php endif; ?>
<?php if (isset($__attributesOriginalc7e006f324f287080794af0ddf69bd8d)): ?>
<?php $attributes = $__attributesOriginalc7e006f324f287080794af0ddf69bd8d; ?>
<?php unset($__attributesOriginalc7e006f324f287080794af0ddf69bd8d); ?>
<?php endif; ?>
<?php if (isset($__componentOriginalc7e006f324f287080794af0ddf69bd8d)): ?>
<?php $component = $__componentOriginalc7e006f324f287080794af0ddf69bd8d; ?>
<?php unset($__componentOriginalc7e006f324f287080794af0ddf69bd8d); ?>
<?php endif; ?>
                    </li>
                    <?php endif; ?>
                    <?php if(auth()->guard()->guest()): ?>
                    <li class="nav-item">
                        <a class="nav-link" href="<?php echo e(route('register')); ?>">Sign Up</a>
                    </li>
                    <?php endif; ?>
                </ul>
            </div>
        </nav>
    </header>

    <main>
        <?php echo $__env->yieldContent('content'); ?>
    </main>
    
    <?php
$__split = function ($name, $params = []) {
    return [$name, $params];
};
[$__name, $__params] = $__split('footer');

$__html = app('livewire')->mount($__name, $__params, 'lw-3403229391-1', $__slots ?? [], get_defined_vars());

echo $__html;

unset($__html);
unset($__name);
unset($__params);
unset($__split);
if (isset($__slots)) unset($__slots);
?>

    <script src="/assets/js/jquery-3.4.1.min.js"></script>
    <script src="/assets/js/popper.min.js"></script>
    <script src="/assets/js/bootstrap.min.js"></script>
    <script src="/assets/js/amcharts-core.min.js"></script>
    <script src="/assets/js/amcharts.min.js"></script>
    <script src="/assets/js/custom.js"></script>
    <script src="https://s3.tradingview.com/tv.js"></script>
    <script src="https://cdnjs.cloudflare.com/ajax/libs/toastr.js/latest/toastr.min.js"></script>
    <?php echo \Livewire\Mechanisms\FrontendAssets\FrontendAssets::scripts(); ?>

    <script>
        window.addEventListener('alert', event => {
             toastr[event.detail[0].type](event.detail[0].message, event.detail[0].title ?? '')
             toastr.options = {
                "closeButton": true,
                "progressBar": true,
                "positionClass": "toast-bottom-right",
            }
        });

        // Update footer tab active state based on URL
        function updateFooterActiveTab() {
            const urlParams = new URLSearchParams(window.location.search);
            const tab = urlParams.get('tab');
            
            // Remove active class from all items
            document.querySelectorAll('.mobile-menu-item').forEach(item => {
                item.classList.remove('active');
            });
            
            // Add active class to the correct tab
            if (!tab || tab === '') {
                // Trade tab (no tab parameter)
                const tradeLink = document.querySelector('.mobile-menu-item[href="/"]');
                if (tradeLink) tradeLink.classList.add('active');
            } else if (tab === 'market') {
                const marketLink = document.querySelector('.mobile-menu-item[href="/?tab=market"]');
                if (marketLink) marketLink.classList.add('active');
            } else if (tab === 'positions') {
                const positionsLink = document.querySelector('.mobile-menu-item[href="/?tab=positions"]');
                if (positionsLink) positionsLink.classList.add('active');
            } else if (tab === 'history') {
                const historyLink = document.querySelector('.mobile-menu-item[href="/?tab=history"]');
                if (historyLink) historyLink.classList.add('active');
            }
        }
        
        // Update on page load
        document.addEventListener('DOMContentLoaded', updateFooterActiveTab);
        
        // Update when Livewire navigates (using wire:navigate)
        document.addEventListener('livewire:navigated', updateFooterActiveTab);
        
        // Also update periodically to catch any URL changes
        setInterval(updateFooterActiveTab, 500);
    </script>
</body>
</html> <?php /**PATH C:\Users\indri\prjct\webtrader12-01\webtrader\resources\views/layouts/app.blade.php ENDPATH**/ ?>