<div class="container-fluid px-4">
<div class="row">
    <div class="col-12">
        <div class="card">
            <div class="card-header">
                <div class="mb-3">
                    <i class="icon ion-md-pricetag mr-1"></i>
                    Promo Codes Management
                </div>
                
                <ul class="nav nav-pills card-header-pills">
                    <li class="nav-item mr-5">
                        <div class="input-group" style="width: 250px;">
                            <input type="text" wire:model.live="search" class="form-control float-right" placeholder="Search...">
                            <div class="input-group-append">
                                <button type="submit" class="btn btn-secondary">
                                    <i class="icon ion-md-search"></i>
                                </button>
                            </div>
                        </div>
                    </li>
                    <li class="nav-item">
                        <button type="button" class="btn btn-primary" wire:click.prevent="openAddModal()">Add Promo Code</button>
                    </li>
                </ul>
            </div>
            <div class="card-body table-responsive p-0">
                <table class="table table-hover text-nowrap">
                    <thead>
                        <tr>
                            <th wire:click="sortBy('id')" style="cursor: pointer;">
                                ID
                                <!--[if BLOCK]><![endif]--><?php if($sortField === 'id'): ?>
                                    <i class="fas fa-sort-<?php echo e($sortDirection === 'asc' ? 'up' : 'down'); ?>"></i>
                                <?php endif; ?><!--[if ENDBLOCK]><![endif]-->
                            </th>
                            <th wire:click="sortBy('code')" style="cursor: pointer;">
                                Code
                                <!--[if BLOCK]><![endif]--><?php if($sortField === 'code'): ?>
                                    <i class="fas fa-sort-<?php echo e($sortDirection === 'asc' ? 'up' : 'down'); ?>"></i>
                                <?php endif; ?><!--[if ENDBLOCK]><![endif]-->
                            </th>
                            <th wire:click="sortBy('description')" style="cursor: pointer;">
                                Description
                                <!--[if BLOCK]><![endif]--><?php if($sortField === 'description'): ?>
                                    <i class="fas fa-sort-<?php echo e($sortDirection === 'asc' ? 'up' : 'down'); ?>"></i>
                                <?php endif; ?><!--[if ENDBLOCK]><![endif]-->
                            </th>
                            <th wire:click="sortBy('created_at')" style="cursor: pointer;">
                                Created At
                                <!--[if BLOCK]><![endif]--><?php if($sortField === 'created_at'): ?>
                                    <i class="fas fa-sort-<?php echo e($sortDirection === 'asc' ? 'up' : 'down'); ?>"></i>
                                <?php endif; ?><!--[if ENDBLOCK]><![endif]-->
                            </th>
                            <th>Actions</th>
                        </tr>
                    </thead>
                    <tbody>
                        <!--[if BLOCK]><![endif]--><?php $__empty_1 = true; $__currentLoopData = $promoCodes; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $promoCode): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                        <tr>
                            <td><?php echo e($promoCode->id); ?></td>
                            <td><strong><?php echo e($promoCode->code); ?></strong></td>
                            <td><?php echo e($promoCode->description); ?></td>
                            <td><?php echo e($promoCode->created_at ? $promoCode->created_at->format('Y-m-d H:i') : 'N/A'); ?></td>
                            <td>
                                <button class="btn btn-sm btn-danger" wire:click="confirmDelete(<?php echo e($promoCode->id); ?>)">
                                    <i class="fas fa-trash"></i> Delete
                                </button>
                            </td>
                        </tr>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                        <tr>
                            <td colspan="5" class="text-center">No promo codes found</td>
                        </tr>
                        <?php endif; ?><!--[if ENDBLOCK]><![endif]-->
                    </tbody>
                </table>
            </div>
            <div class="card-footer clearfix pagination-container">
                <div class="w-100">
                    <?php echo e($promoCodes->links()); ?>

                </div>
            </div>
        </div>
    </div>
</div>

<!-- Add Promo Code Modal -->
<!--[if BLOCK]><![endif]--><?php if($showAddModal): ?>
<div class="modal fade show" style="display: block;" tabindex="-1" role="dialog">
    <div class="modal-dialog" role="document">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title">Add New Promo Code</h5>
                <button type="button" class="close" wire:click="$set('showAddModal', false)">
                    <span aria-hidden="true">&times;</span>
                </button>
            </div>
            <div class="modal-body">
                <div class="form-group">
                    <label>Code</label>
                    <input type="text" class="form-control" wire:model="code" placeholder="Enter promo code">
                    <!--[if BLOCK]><![endif]--><?php $__errorArgs = ['code'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> <span class="text-danger"><?php echo e($message); ?></span> <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?><!--[if ENDBLOCK]><![endif]-->
                </div>
                <div class="form-group">
                    <label>Description</label>
                    <textarea class="form-control" wire:model="description" rows="3" placeholder="Enter description"></textarea>
                    <!--[if BLOCK]><![endif]--><?php $__errorArgs = ['description'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> <span class="text-danger"><?php echo e($message); ?></span> <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?><!--[if ENDBLOCK]><![endif]-->
                </div>
            </div>
            <div class="modal-footer">
                <button type="button" class="btn btn-secondary" wire:click="$set('showAddModal', false)">Cancel</button>
                <button type="button" class="btn btn-primary" wire:click="createPromoCode">Add Promo Code</button>
            </div>
        </div>
    </div>
</div>
<div class="modal-backdrop fade show"></div>
<?php endif; ?><!--[if ENDBLOCK]><![endif]-->

<!-- Edit Promo Code Modal -->
<!--[if BLOCK]><![endif]--><?php if($showEditModal): ?>
<div class="modal fade show" style="display: block;" tabindex="-1" role="dialog">
    <div class="modal-dialog" role="document">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title">Edit Promo Code</h5>
                <button type="button" class="close" wire:click="$set('showEditModal', false)">
                    <span aria-hidden="true">&times;</span>
                </button>
            </div>
            <div class="modal-body">
                <div class="form-group">
                    <label>Code</label>
                    <input type="text" class="form-control" wire:model="code" placeholder="Enter promo code">
                    <!--[if BLOCK]><![endif]--><?php $__errorArgs = ['code'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> <span class="text-danger"><?php echo e($message); ?></span> <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?><!--[if ENDBLOCK]><![endif]-->
                </div>
                <div class="form-group">
                    <label>Description</label>
                    <textarea class="form-control" wire:model="description" rows="3" placeholder="Enter description"></textarea>
                    <!--[if BLOCK]><![endif]--><?php $__errorArgs = ['description'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> <span class="text-danger"><?php echo e($message); ?></span> <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?><!--[if ENDBLOCK]><![endif]-->
                </div>
            </div>
            <div class="modal-footer">
                <button type="button" class="btn btn-secondary" wire:click="$set('showEditModal', false)">Cancel</button>
                <button type="button" class="btn btn-primary" wire:click="updatePromoCode">Update Promo Code</button>
            </div>
        </div>
    </div>
</div>
<div class="modal-backdrop fade show"></div>
<?php endif; ?><!--[if ENDBLOCK]><![endif]-->

<!-- Delete Confirmation Modal -->
<!--[if BLOCK]><![endif]--><?php if($showDeleteModal): ?>
<div class="modal fade show" style="display: block;" tabindex="-1" role="dialog">
    <div class="modal-dialog" role="document">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title">Delete Promo Code</h5>
                <button type="button" class="close" wire:click="$set('showDeleteModal', false)">
                    <span aria-hidden="true">&times;</span>
                </button>
            </div>
            <div class="modal-body">
                <p>Are you sure you want to delete this promo code? This action cannot be undone.</p>
            </div>
            <div class="modal-footer">
                <button type="button" class="btn btn-secondary" wire:click="$set('showDeleteModal', false)">Cancel</button>
                <button type="button" class="btn btn-danger" wire:click="deletePromoCode">Delete</button>
            </div>
        </div>
    </div>
</div>
<div class="modal-backdrop fade show"></div>
<?php endif; ?><!--[if ENDBLOCK]><![endif]-->

<!--[if BLOCK]><![endif]--><?php if(session()->has('message')): ?>
    <div class="alert alert-success">
        <?php echo e(session('message')); ?>

    </div>
<?php endif; ?><!--[if ENDBLOCK]><![endif]--> 
</div><?php /**PATH C:\Users\indri\prjct\webtrader12-01\webtrader\resources\views/livewire/admin-promo-codes.blade.php ENDPATH**/ ?>