

<?php $__env->startSection('content'); ?>
<div class="container-fluid">
    <div class="row">
        <!-- Right: User Info Form -->
        <div class="col-md-4 mb-4">
            <div class="card">
                <div class="card-header d-flex align-items-center justify-content-between">
                    <div>
                        <i class="icon ion-md-map mr-1"></i>
                        Edit User #<?php echo e($user->id); ?>

                    </div>
                    <div>
                        Status:
                        <?php if($user->isOnline()): ?>
                            <span class="badge badge-success">Online</span>
                        <?php else: ?>
                            <span class="badge badge-secondary">Offline</span>
                        <?php endif; ?>
                    </div>
                </div>
                <div class="card-body">
                    <form method="POST" action="<?php echo e(route('admin.users.edit', $user->id)); ?>">
                        <?php echo csrf_field(); ?>
                        <?php echo method_field('PUT'); ?>
                        <div class="form-group">
                            <label>Name</label>
                            <input type="text" name="name" class="form-control" value="<?php echo e(old('name', $user->name)); ?>" required>
                        </div>
                        <div class="form-group">
                            <label>Email</label>
                            <input type="email" name="email" class="form-control" value="<?php echo e(old('email', $user->email)); ?>" required>
                        </div>
                        <div class="form-group">
                            <label>Login ID</label>
                            <input type="text" name="login" class="form-control" value="<?php echo e(old('login', $user->login)); ?>" required>
                        </div>
                        <div class="form-group">
                            <label>Password</label>
                            <input type="password" name="password" class="form-control" placeholder="Leave blank to keep current password">
                        </div>
                        <div class="form-group">
                            <label>Promo Code</label>
                            <input type="text" name="promo_code" class="form-control" value="<?php echo e(old('promo_code', $user->promo_code)); ?>">
                        </div>
                        
                        <div class="form-group">
                            <label>Phone Number</label>
                            <input type="number" name="phone_number" class="form-control" value="<?php echo e(old('phone_number', $user->phone_number)); ?>">
                        </div>
                        <div class="form-group">
                            <label>Address</label>
                            <input type="text" name="address" class="form-control" value="<?php echo e(old('address', $user->address->address ?? '')); ?>">
                        </div>
                        <?php if(auth()->user()->hasRole('admin')): ?>
                        <div class="form-group">
                            <label>Roles</label>
                            <select name="roles[]" class="form-control">
                                <?php $__currentLoopData = $roles; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $role): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <option value="<?php echo e($role->id); ?>" <?php echo e($user->roles->contains($role->id) ? 'selected' : ''); ?>><?php echo e($role->name); ?></option>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            </select>
                        </div>
                        <?php if(!$user->hasRole('manager') && !$user->hasRole('admin')): ?>
                        <div class="form-group">
                            <label>Manager</label>
                            <select name="manager_id" class="form-control">
                                <option value="">Select Manager</option>
                                <?php $__currentLoopData = $managers; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $manager): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <option value="<?php echo e($manager->id); ?>" <?php echo e($user->manager_id == $manager->id ? 'selected' : ''); ?>><?php echo e($manager->name); ?></option>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            </select>
                        </div>
                        <?php endif; ?>
                        <?php endif; ?>
                        <div class="mt-3">
                            <button type="submit" class="btn btn-success">Save Changes</button>
                            <a href="<?php echo e(route('admin.users')); ?>" class="btn btn-secondary">Back</a>
                            <?php if($showLoginAsButton): ?>
                            <a href="<?php echo e(route('admin.users.login-as', $user->id)); ?>" class="btn btn-primary">
                                <i class="icon ion-md-log-in mr-1"></i> Login as User
                            </a>
                            <?php endif; ?>
                        </div>
                    </form>
                </div>
            </div>
        </div>
        <!-- Right: Tabs for Sessions and Comments -->
        <div class="col-md-8 mb-4">
            <div class="card">
                <div class="card-body">
                    <ul class="nav nav-tabs" id="userTab" role="tablist">
                        <li class="nav-item">
                            <a class="nav-link active" id="sessions-tab" data-toggle="tab" href="#sessions" role="tab" aria-controls="sessions" aria-selected="true">Recent Sessions</a>
                        </li>
                        <li class="nav-item">
                            <a class="nav-link" id="comments-tab" data-toggle="tab" href="#comments" role="tab" aria-controls="comments" aria-selected="false">Comments</a>
                        </li>
                    </ul>
                    <div class="tab-content mt-3" id="userTabContent">
                        <!-- Sessions Tab -->
                        <div class="tab-pane fade show active" id="sessions" role="tabpanel" aria-labelledby="sessions-tab">
                            <div class="table-responsive">
                                <table class="table table-sm">
                                    <thead>
                                        <tr>
                                            <th>Login At</th>
                                            <th>Logout At</th>
                                            <th>Duration</th>
                                            <th>IP Address</th>
                                        </tr>
                                    </thead>
                                    <tbody>
                                        <?php $__currentLoopData = $sessions; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $session): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                            <tr>
                                                <td><?php echo e($session->login_at); ?></td>
                                                <td><?php echo e($session->logout_at ?? '-'); ?></td>
                                                <td>
                                                    <?php if($session->logout_at): ?>
                                                        <?php echo e($session->login_at->diffForHumans($session->logout_at, true)); ?>

                                                    <?php else: ?>
                                                        <?php echo e(now()->diffForHumans($session->login_at, true)); ?>

                                                    <?php endif; ?>
                                                </td>
                                                <td><?php echo e($session->ip_address); ?></td>
                                            </tr>
                                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                    </tbody>
                                </table>
                            </div>
                        </div>
                        <!-- Comments Tab -->
                        <div class="tab-pane fade" id="comments" role="tabpanel" aria-labelledby="comments-tab">
                            <form method="POST" action="<?php echo e(route('admin.users.comments.add', $user->id)); ?>" class="mb-3">
                                <?php echo csrf_field(); ?>
                                <div class="input-group">
                                    <input type="text" name="content" class="form-control" placeholder="Add a comment..." required>
                                    <div class="input-group-append">
                                        <button class="btn btn-primary" type="submit">Add</button>
                                    </div>
                                </div>
                            </form>
                            <ul class="list-group">
                                <?php $__currentLoopData = $user->comments->sortByDesc('created_at'); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $comment): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <li class="list-group-item d-flex justify-content-between align-items-center">
                                        <span><?php echo e($comment->content); ?> <span class="text-muted"> (<?php echo e($comment->created_at->diffForHumans()); ?>)</span></span>
                                    </li>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            </ul>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>
<?php $__env->stopSection(); ?> 
<?php echo $__env->make('layouts.admin', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH C:\Users\indri\prjct\webtrader12-01\webtrader\resources\views/admin/edit-user.blade.php ENDPATH**/ ?>