<?php

namespace App\Livewire;

use Livewire\Component;
use App\Models\User;
use Illuminate\Support\Facades\Auth;

class HeaderMobileStats extends Component
{
    public $balance;
    public $unrealizedPL;

    public function mount()
    {
        $this->updateStats();
    }

    public function updateStats()
    {
        if (Auth::check()) {
            $user = Auth::user();
            $this->balance = $user->confirmedBalance();
            $this->unrealizedPL = $user->calculateTotalUnrealizedPL();
        } else {
            $this->balance = 0;
            $this->unrealizedPL = 0;
        }
    }

    public function render()
    {
        return view('livewire.header-mobile-stats');
    }
}

