<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;

class CurrencyType extends Model
{
    protected $table = 'currency_types';
    
    protected $fillable = [
        'name',
        'code',
        'order',
        'enabled'
    ];

    protected $casts = [
        'enabled' => 'boolean'
    ];

    public function currencies()
    {
        return $this->hasMany('App\Models\Currency', 'type_id');
    }

    public function scopeOrdered($query)
    {
        return $query->orderBy('order');
    }
}
