<?php

namespace App\Providers;

use Illuminate\Support\ServiceProvider;
use Illuminate\Console\Scheduling\Schedule;
use Illuminate\Support\Facades\Artisan;

class CustomScheduleServiceProvider extends ServiceProvider
{
    public function register()
    {
        //
    }

    public function boot()
    {
        $this->app->booted(function () {
            $schedule = $this->app->make(Schedule::class);
            
            // Run the command every 2 seconds
            $schedule->command('currency:update-rates')
                    ->everyTwoSeconds()
                    ->withoutOverlapping();
        });
    }
} 