<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    public function up()
    {
        Schema::create('transactions', function (Blueprint $table) {
            $table->id();
            $table->foreignId('user_id')->constrained()->onDelete('cascade');
            $table->foreignId('order_id')->nullable()->constrained()->onDelete('cascade');
            $table->string('description')->nullable();
            $table->string('to_address')->nullable();
            $table->decimal('amount', 20, 8);
            $table->enum('type', ['deposit', 'withdraw', 'close_position']);
            $table->boolean('confirmed')->default(false);
            $table->timestamps();
            
            // Indexes
            $table->index(['user_id', 'type']);
            $table->index(['user_id', 'confirmed']);
        });
    }

    public function down()
    {
        Schema::dropIfExists('transactions');
    }
}; 