<div>
<div class="row">
    <div class="col-12">
        <div class="card">
            <div class="card-header">
                <div class="mb-3">
                    <i class="icon ion-md-list-box mr-1"></i>
                    Orders Management
                </div>
                
                <ul class="nav nav-pills card-header-pills">
                    <li class="nav-item mr-5">
                        <div class="input-group" style="width: 250px;">
                            <input type="text" wire:model.live="search" class="form-control float-right" placeholder="Search...">
                            <div class="input-group-append">
                                <button type="submit" class="btn btn-secondary">
                                    <i class="icon ion-md-search"></i>
                                </button>
                            </div>
                        </div>
                    </li>
                    <li class="nav-item mr-3">
                        <select wire:model.live="perPage" class="form-control">
                            <option value="10">10 per page</option>
                            <option value="25">25 per page</option>
                            <option value="50">50 per page</option>
                            <option value="100">100 per page</option>
                        </select>
                    </li>
                </ul>
            </div>
            <div class="card-body table-responsive p-0">
                <table class="table table-hover text-nowrap">
                    <thead>
                        <tr>
                            <th wire:click="sortBy('id')" style="cursor: pointer;">
                                ID
                                @if($sortField === 'id')
                                    <i class="fas fa-sort-{{ $sortDirection === 'asc' ? 'up' : 'down' }}"></i>
                                @endif
                            </th>
                            <th wire:click="sortBy('user_id')" style="cursor: pointer;">
                                User
                                @if($sortField === 'user_id')
                                    <i class="fas fa-sort-{{ $sortDirection === 'asc' ? 'up' : 'down' }}"></i>
                                @endif
                            </th>
                            <th wire:click="sortBy('currency_id')" style="cursor: pointer;">
                                Currency
                                @if($sortField === 'currency_id')
                                    <i class="fas fa-sort-{{ $sortDirection === 'asc' ? 'up' : 'down' }}"></i>
                                @endif
                            </th>
                            <th>Type</th>
                            <th wire:click="sortBy('volume')" style="cursor: pointer;">
                                Volume
                                @if($sortField === 'volume')
                                    <i class="fas fa-sort-{{ $sortDirection === 'asc' ? 'up' : 'down' }}"></i>
                                @endif
                            </th>
                            <th wire:click="sortBy('open_price')" style="cursor: pointer;">
                                Open Price
                                @if($sortField === 'open_price')
                                    <i class="fas fa-sort-{{ $sortDirection === 'asc' ? 'up' : 'down' }}"></i>
                                @endif
                            </th>
                            <th>Current Price</th>
                            <th>Take Profit</th>
                            <th>Stop Loss</th>
                            <th wire:click="sortBy('status')" style="cursor: pointer;">
                                Status
                                @if($sortField === 'status')
                                    <i class="fas fa-sort-{{ $sortDirection === 'asc' ? 'up' : 'down' }}"></i>
                                @endif
                            </th>
                            <th wire:click="sortBy('open_time')" style="cursor: pointer;">
                                Open Time
                                @if($sortField === 'open_time')
                                    <i class="fas fa-sort-{{ $sortDirection === 'asc' ? 'up' : 'down' }}"></i>
                                @endif
                            </th>
                            <th wire:click="sortBy('close_time')" style="cursor: pointer;">
                                Close Time
                                @if($sortField === 'close_time')
                                    <i class="fas fa-sort-{{ $sortDirection === 'asc' ? 'up' : 'down' }}"></i>
                                @endif
                            </th>
                            <th wire:click="sortBy('pl')" style="cursor: pointer;">
                                P/L
                                @if($sortField === 'pl')
                                    <i class="fas fa-sort-{{ $sortDirection === 'asc' ? 'up' : 'down' }}"></i>
                                @endif
                            </th>
                            <th>Actions</th>
                        </tr>
                    </thead>
                    <tbody>
                        @foreach($orders as $order)
                        <tr>
                            <td>{{ $order->id }}</td>
                            <td>{{ $order->user->name }}</td>
                            <td>{{ $order->currency->name }}</td>
                            <td>
                                <span class="badge badge-{{ $order->side === 'buy' ? 'success' : 'danger' }}">
                                    {{ strtoupper($order->side) }}
                                </span>
                            </td>
                            <td>{{ $order->formatted_volume }}</td>
                            <td>{{ $order->formatted_open_price }}</td>
                            <td>
                                @if($order->status == 'open')
                                    {{ $order->side === 'buy' ? $order->currency->formatted_bid : $order->currency->formatted_ask }}
                                @else
                                    {{ $order->formatted_close_price }}
                                @endif
                            </td>
                            <td>{{ $order->take_profit ? $order->formatted_take_profit : '-' }}</td>
                            <td>{{ $order->stop_loss ? $order->formatted_stop_loss : '-' }}</td>
                            <td>
                                <span class="badge badge-{{ $order->status == 'open' ? 'primary' : 'secondary' }}">
                                    {{ $order->status == 'open' ? 'Open' : 'Closed' }}
                                </span>
                            </td>
                            <td>{{ $order->open_time->format('Y-m-d H:i:s') }}</td>
                            <td>{{ $order->close_time ? $order->close_time->format('Y-m-d H:i:s') : '-' }}</td>
                            <td class="{{ $order->getPLStatus() }}">
                                {{ $order->getFormattedPL() }}
                            </td>
                            <td>
                                <button class="btn btn-sm btn-info" wire:click="editOrder({{ $order->id }})" data-toggle="modal" data-target="#editOrderModal">
                                    <i class="fas fa-edit"></i> Edit
                                </button>
                                @if($order->status == 'open')
                                    <button class="btn btn-sm btn-warning" wire:click="closeOrder({{ $order->id }})" wire:confirm="Are you sure you want to close this order?">
                                        <i class="fas fa-times-circle"></i> Close
                                    </button>
                                @endif
                                <button class="btn btn-sm btn-danger" wire:click="deleteOrder({{ $order->id }})" wire:confirm="Are you sure you want to delete this order?">
                                    <i class="fas fa-trash"></i> Delete
                                </button>
                            </td>
                        </tr>
                        @endforeach
                    </tbody>
                </table>
            </div>

            <div class="card-footer clearfix pagination-container">
                <div class="w-100">
                    {{ $orders->links() }}
                </div>
            </div>
        </div>
    </div>
</div>

<!-- Edit Order Modal -->
<div class="modal fade" id="editOrderModal" tabindex="-1" role="dialog" aria-labelledby="editOrderModalLabel" aria-hidden="true" wire:ignore.self>
    <div class="modal-dialog modal-lg" role="document">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title" id="editOrderModalLabel">Edit Order #{{ $editingOrder->id ?? '' }}</h5>
                <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                    <span aria-hidden="true">&times;</span>
                </button>
            </div>
            <div class="modal-body">
                @if($editingOrder)
                    <form wire:submit.prevent="updateOrder">
                        <div class="row">
                            <div class="col-md-6">
                                <div class="form-group">
                                    <label>User <span class="text-muted small">(read-only)</span></label>
                                    <input type="text" class="form-control bg-secondary" value="{{ $editingOrder->user->name }}" readonly>
                                </div>
                            </div>
                            <div class="col-md-6">
                                <div class="form-group">
                                    <label>Currency <span class="text-muted small">(read-only)</span></label>
                                    <input type="text" class="form-control bg-secondary" value="{{ $editingOrder->currency->name }}" readonly>
                                </div>
                            </div>
                        </div>

                        <div class="row">
                            <div class="col-md-6">
                                <div class="form-group">
                                    <label>Type <span class="text-muted small">(read-only)</span></label>
                                    <input type="text" class="form-control bg-secondary" value="{{ strtoupper($editingOrder->side) }}" readonly>
                                </div>
                            </div>
                            <div class="col-md-6">
                                <div class="form-group">
                                    <label>Status <span class="text-muted small">(read-only)</span></label>
                                    <input type="text" class="form-control bg-secondary" value="{{ $editingOrder->status == 'open' ? 'Open' : 'Closed' }}" readonly>
                                </div>
                            </div>
                        </div>

                        <div class="row">
                            <div class="col-md-6">
                                <div class="form-group">
                                    <label for="editVolume">Volume</label>
                                    <input type="number" class="form-control" id="editVolume" wire:model="editVolume" step="0.1" min="0.1">
                                </div>
                            </div>
                            <div class="col-md-6">
                                <div class="form-group">
                                    <label for="editFee">Fee</label>
                                    <input type="number" class="form-control" id="editFee" wire:model="editFee" step="0.01" min="0">
                                </div>
                            </div>
                        </div>

                        <div class="row">
                            <div class="col-md-6">
                                <div class="form-group">
                                    <label for="editOpenPrice">Open Price</label>
                                    <input type="number" class="form-control" id="editOpenPrice" wire:model="editOpenPrice" step="0.00001" min="0">
                                </div>
                            </div>
                            <div class="col-md-6">
                                <div class="form-group">
                                    <label for="editOpenTime">Open Time</label>
                                    <input type="datetime-local" class="form-control" id="editOpenTime" wire:model="editOpenTime">
                                </div>
                            </div>
                        </div>

                        <div class="row">
                            <div class="col-md-6">
                                <div class="form-group">
                                    <label for="editTakeProfit">Take Profit</label>
                                    <input type="number" class="form-control" id="editTakeProfit" wire:model="editTakeProfit" step="0.00001" min="0">
                                </div>
                            </div>
                            <div class="col-md-6">
                                <div class="form-group">
                                    <label for="editStopLoss">Stop Loss</label>
                                    <input type="number" class="form-control" id="editStopLoss" wire:model="editStopLoss" step="0.00001" min="0">
                                </div>
                            </div>
                        </div>

                        @if($editingOrder->status == 'closed')
                            <div class="row">
                                <div class="col-md-6">
                                    <div class="form-group">
                                        <label for="editClosePrice">Close Price</label>
                                        <input type="number" class="form-control" id="editClosePrice" wire:model="editClosePrice" step="0.00001" min="0">
                                    </div>
                                </div>
                                <div class="col-md-6">
                                    <div class="form-group">
                                        <label for="editCloseTime">Close Time</label>
                                        <input type="datetime-local" class="form-control" id="editCloseTime" wire:model="editCloseTime">
                                    </div>
                                </div>
                            </div>
                        @endif

                        <div class="row">
                            <div class="col-md-12">
                                <div class="form-group">
                                    <label>P/L <span class="text-muted small">(read-only)</span></label>
                                    <input type="text" class="form-control bg-secondary {{ $editingOrder->getPLStatus() }}" value="{{ $editingOrder->getFormattedPL() }}" readonly>
                                </div>
                            </div>
                        </div>
                    </form>
                @endif
            </div>
            <div class="modal-footer">
                <button type="button" class="btn btn-secondary" data-dismiss="modal">Close</button>
                <button type="button" class="btn btn-primary" wire:click="updateOrder" data-dismiss="modal">Save changes</button>
            </div>
        </div>
    </div>
</div>

@if (session()->has('message'))
    <div class="alert alert-success">
        {{ session('message') }}
    </div>
@endif
</div>