<div class="wallet">
    <div class="container-fluid settings">
        <div class="row mt-4">
            <div class="col-md-12 col-lg-6">
                <div class="card wallet">
                    <div class="card-body">
                    <h5 class="card-title">Balances</h5>
                    <ul>
                        <li class="d-flex justify-content-between align-items-center">
                        <div class="d-flex align-items-center">
                            <i class="icon ion-md-cash"></i>
                            <h2>Equity</h2>
                        </div>
                        <div>
                            <h3>{{ number_format(Auth::user()->getFormattedTotalUnrealizedPL() + Auth::user()->confirmedBalance(), 2) }} USD</h3>
                        </div>
                        </li>
                        <li class="d-flex justify-content-between align-items-center">
                        <div class="d-flex align-items-center">
                            <i class="icon ion-md-checkmark"></i>
                            <h2>Free Margin</h2>
                        </div>
                        <div>
                            <h3>{{ Auth::user()->getFormattedFreeMargin() }} USD</h3>
                        </div>
                        </li>
                    </ul>
                    <button wire:click="openDepositModal" class="btn green">Deposit</button>
                    <button wire:click="openWithdrawModal" class="btn red">Withdraw</button>
                    

                    @if (session()->has('message'))
                        <div class="alert alert-success alert-dismissible fade show" role="alert">
                            {{ session('message') }}
                            <button type="button" class="close" data-dismiss="alert" aria-label="Close">
                                <span aria-hidden="true">&times;</span>
                            </button>
                        </div>
                    @endif

                    @if (session()->has('error'))
                        <div class="alert alert-danger alert-dismissible fade show" role="alert">
                            {{ session('error') }}
                            <button type="button" class="close" data-dismiss="alert" aria-label="Close">
                                <span aria-hidden="true">&times;</span>
                            </button>
                        </div>
                    @endif
                    </div>
                    
                </div>
            </div>
            
            <div class="col-md-12 col-lg-6">
                <div class="card">
                    <div class="card-body">
                        <h5 class="card-title">Wallet Deposit Address</h5>
                        <div class="row wallet-address">
                            <div class="col-md-8">
                            <p>Deposits to this address are unlimited.</p>
                            <div class="input-group">
                                <input type="text" class="form-control" value="{{ Auth::user()->getWalletAddress() }}">
                                <div class="input-group-prepend">
                                    <button class="btn btn-primary" onclick="copyToClipboard('{{ Auth::user()->getWalletAddress() }}')">COPY</button>
                                </div>
                            </div>
                            </div>
                            <div class="col-md-4">
                                <div class="qr-code-container" wire:ignore>
                                    @if(Auth::user()->getWalletAddress())
                                        {!! DNS2D::getBarcodeHTML(Auth::user()->getWalletAddress(), 'QRCODE', 10,10,'white') !!}
                                    @else
                                        <p>No wallet address found</p>
                                    @endif
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
        <div class="row">
            <div class="col-md-12 col-lg-12">
                <div class="card">
                    <div class="card-body">
                    <h5 class="card-title mt-4">Recent Transactions</h5>
                        <div class="table-responsive">
                            
                            <table class="table">
                                <thead>
                                    <tr>
                                        <th>Date</th>
                                        <th>Type</th>
                                        <th>Amount</th>
                                        <th>To Address</th>
                                        <th>Status</th>
                                    </tr>
                                </thead>
                                <tbody>
                                    @forelse ($transactions as $transaction)
                                        <tr>
                                            <td>{{ $transaction->created_at ? $transaction->created_at->format('Y-m-d H:i') : '-' }}</td>
                                            <td>
                                                <span class="badge badge-{{ $transaction->type === 'deposit' ? 'success' : 'warning' }}">
                                                    {{ ucfirst($transaction->type) }}
                                                </span>
                                            </td>
                                            <td>{{ number_format($transaction->amount, 2) }} USD</td>
                                            <td>{{ $transaction->to_address }}</td>
                                            <td>
                                                @if($transaction->confirmed == 1)
                                                    <i class="icon ion-md-checkmark-circle-outline green"></i>
                                                @else
                                                    <i class="icon ion-md-close-circle-outline red"></i>
                                                @endif
                                            </td>
                                        </tr>
                                    @empty
                                        <tr>
                                            <td colspan="5 class="text-center">No transactions found</td>
                                        </tr>
                                    @endforelse
                                </tbody>
                            </table>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <!-- Deposit Modal -->
    @if($showDepositModal)
    <div class="modal fade show" style="display: block;" tabindex="-1" role="dialog">
        <div class="modal-dialog" role="document">
            <div class="modal-content">
                <div class="modal-header">
                    <h5 class="modal-title">Initiate Deposit</h5>
                    <button type="button" class="close" wire:click="closeModal">
                        <span aria-hidden="true">&times;</span>
                    </button>
                </div>
                <div class="modal-body">
                    <form wire:submit="initiateDeposit">
                        <div class="form-group">
                            <label>Amount</label>
                            <input type="number" step="0.01" class="form-control" wire:model="amount">
                            @error('amount') <span class="text-danger">{{ $message }}</span> @enderror
                        </div>
                        <div class="modal-footer">
                            <button type="button" class="btn btn-secondary" wire:click="closeModal">Cancel</button>
                            <button type="submit" class="btn btn-primary">Continue</button>
                        </div>
                    </form>
                </div>
            </div>
        </div>
    </div>
    <div class="modal-backdrop fade show"></div>
    @endif

    <!-- Deposit Address Modal -->
    @if($showDepositAddressModal)
    <div class="modal fade show" style="display: block;" tabindex="-1" role="dialog">
        <div class="modal-dialog" role="document">
            <div class="modal-content">
            <div class="modal-header">
                    <h5 class="modal-title">Wallet Deposit Address</h5>
                    <button type="button" class="close" wire:click="closeModal">
                        <span aria-hidden="true">&times;</span>
                    </button>
                </div>
                <div class="modal-body">
                    <div class="row wallet-address">
                        
                        <div class="col-md-12">
                            <div class="qr-code-container-modal">
                                @if(Auth::user()->getWalletAddress())
                                    {!! DNS2D::getBarcodeHTML(Auth::user()->getWalletAddress(), 'QRCODE', 10,10,'white') !!}
                                @else
                                    <p>No wallet address found</p>
                                @endif
                            </div>
                        </div>
                        <div class="col-md-12">
                            <div class="input-group">
                                <input type="text" class="form-control" value="{{ Auth::user()->getWalletAddress() }}" readonly>
                                <div class="input-group-prepend">
                                    <button class="btn btn-primary" onclick="copyToClipboard('{{ Auth::user()->getWalletAddress() }}')">COPY</button>
                                </div>
                            </div>
                        </div>
                    </div>
                    <div class="mt-4">
                        <div class="alert alert-info">
                            <i class="icon ion-md-information-circle-outline"></i>
                            Please send exactly {{ number_format($amount, 2) }} to the address above.
                        </div>
                    </div>
                </div>
                <div class="modal-footer">
                    <button type="button" class="btn btn-secondary" wire:click="closeModal">Close</button>
                </div>
            </div>
        </div>
    </div>
    <div class="modal-backdrop fade show"></div>
    @endif

    <script>
        function copyToClipboard(text) {
            navigator.clipboard.writeText(text).then(function() {
                alert('Address copied to clipboard!');
            }, function(err) {
                console.error('Could not copy text: ', err);
            });
        }
    </script>

    <!-- Withdraw Modal -->
    @if($showWithdrawModal)
    <div class="modal fade show" style="display: block;" tabindex="-1" role="dialog">
        <div class="modal-dialog" role="document">
            <div class="modal-content">
                <div class="modal-header">
                    <h5 class="modal-title">Withdraw Funds</h5>
                    <button type="button" class="close" wire:click="closeModal">
                        <span aria-hidden="true">&times;</span>
                    </button>
                </div>
                <div class="modal-body">
                    <form wire:submit="withdraw">
                        <div class="alert alert-info mb-3">
                            <i class="icon ion-md-information-circle-outline"></i>
                            Maximum withdrawable amount: {{ Auth::user()->confirmedBalance() }} USD
                        </div>
                        <div class="form-group">
                            <label>Amount</label>
                            <input type="number" step="0.00000001" class="form-control @error('amount') is-invalid @enderror" wire:model.live="amount">
                            @error('amount') 
                                <span class="text-danger">{{ $message }}</span>
                            @enderror
                            @if($amount && !$canWithdraw)
                                <span class="text-danger">Amount exceeds your available balance</span>
                            @endif
                        </div>
                        <div class="form-group">
                            <label>To Address</label>
                            <input type="text" class="form-control @error('toAddress') is-invalid @enderror" wire:model="toAddress" placeholder="Enter the destination wallet address">
                            @error('toAddress') 
                                <span class="text-danger">{{ $message }}</span>
                            @enderror
                        </div>
                        <div class="modal-footer">
                            <button type="button" class="btn btn-secondary" wire:click="closeModal">Cancel</button>
                            <button type="submit" class="btn btn-primary" @if(!$canWithdraw) disabled @endif>Withdraw</button>
                        </div>
                    </form>
                </div>
            </div>
        </div>
    </div>
    <div class="modal-backdrop fade show"></div>
    @endif
</div> 