<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <meta http-equiv="X-UA-Compatible" content="ie=edge">
    <title><?php echo e(env('APP_NAME')); ?></title>
    <link rel="icon" href="/assets/img/favicon.png" type="image/x-icon">
    <link rel="stylesheet" href="/assets/css/style.css">
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/toastr.js/latest/toastr.min.css">
    <?php echo \Livewire\Mechanisms\FrontendAssets\FrontendAssets::styles(); ?>

</head>
<body id="dark">
    <header class="dark-bb">
        <nav class="navbar navbar-expand-lg">
            <a class="navbar-brand" href="/"><img src="/assets/img/logo-light.png" alt="logo"></a>
            <button class="navbar-toggler" type="button" data-toggle="collapse" data-target="#headerMenu"
                aria-controls="headerMenu" aria-expanded="false" aria-label="Toggle navigation">
                <i class="icon ion-md-menu"></i>
            </button>

            <div class="collapse navbar-collapse" id="headerMenu">
                <ul class="navbar-nav mr-auto">
                </ul>
                <ul class="navbar-nav ml-auto">
                    <li class="nav-item header-custom-icon">
                        <a class="nav-link" href="#" id="clickFullscreen">
                            <i class="icon ion-md-expand"></i>
                        </a>
                    </li>
                    <?php if(auth()->guard()->check()): ?>
                    <li class="nav-item dropdown header-img-icon">
                        <a class="nav-link dropdown-toggle" href="#" role="button" data-toggle="dropdown" aria-haspopup="true"
                            aria-expanded="false">
                            <img src="/assets/img/avatar.svg" alt="avatar">
                        </a>
                        <?php if (isset($component)) { $__componentOriginalc7e006f324f287080794af0ddf69bd8d = $component; } ?>
<?php if (isset($attributes)) { $__attributesOriginalc7e006f324f287080794af0ddf69bd8d = $attributes; } ?>
<?php $component = App\View\Components\UserDropdown::resolve([] + (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag ? (array) $attributes->getIterator() : [])); ?>
<?php $component->withName('user-dropdown'); ?>
<?php if ($component->shouldRender()): ?>
<?php $__env->startComponent($component->resolveView(), $component->data()); ?>
<?php if (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag && $constructor = (new ReflectionClass(App\View\Components\UserDropdown::class))->getConstructor()): ?>
<?php $attributes = $attributes->except(collect($constructor->getParameters())->map->getName()->all()); ?>
<?php endif; ?>
<?php $component->withAttributes([]); ?>
<?php echo $__env->renderComponent(); ?>
<?php endif; ?>
<?php if (isset($__attributesOriginalc7e006f324f287080794af0ddf69bd8d)): ?>
<?php $attributes = $__attributesOriginalc7e006f324f287080794af0ddf69bd8d; ?>
<?php unset($__attributesOriginalc7e006f324f287080794af0ddf69bd8d); ?>
<?php endif; ?>
<?php if (isset($__componentOriginalc7e006f324f287080794af0ddf69bd8d)): ?>
<?php $component = $__componentOriginalc7e006f324f287080794af0ddf69bd8d; ?>
<?php unset($__componentOriginalc7e006f324f287080794af0ddf69bd8d); ?>
<?php endif; ?>
                    </li>
                    <?php endif; ?>
                    <?php if(auth()->guard()->guest()): ?>
                    <li class="nav-item">
                        <a class="nav-link" href="<?php echo e(route('login')); ?>">Login</a>
                    </li>
                    <li class="nav-item">
                        <a class="nav-link" href="<?php echo e(route('register')); ?>">Sign Up</a>
                    </li>
                    <?php endif; ?>
                </ul>
            </div>
        </nav>
    </header>

    <div class="admin-container">
        <!-- Sidebar -->
        <aside class="admin-sidebar">
            <div class="sidebar-header">
                <h5>Admin Panel</h5>
            </div>
            <ul class="sidebar-menu">
                <li class="menu-item">
                    <a href="<?php echo e(route('admin.dashboard')); ?>" class="menu-link">
                        <i class="icon ion-md-speedometer"></i>
                        <span>Dashboard</span>
                    </a>
                </li>
                <li class="menu-item">
                    <a href="<?php echo e(route('admin.users')); ?>" class="menu-link">
                        <i class="icon ion-md-people"></i>
                        <span>Users</span>
                    </a>
                </li>
                <li class="menu-item">
                    <a href="<?php echo e(route('admin.orders')); ?>" class="menu-link">
                        <i class="icon ion-md-list-box"></i>
                        <span>Orders</span>
                    </a>
                </li>
                <li class="menu-item">
                    <a href="<?php echo e(route('admin.addresses')); ?>" class="menu-link">
                        <i class="icon ion-md-map"></i>
                        <span>Addresses</span>
                    </a>
                </li>
                <li class="menu-item <?php echo e(request()->routeIs('admin.transactions') ? 'active' : ''); ?>">
                    <a href="<?php echo e(route('admin.transactions')); ?>" class="menu-link">
                        <i class="icon ion-md-cash"></i>
                        <span>Transactions</span>
                    </a>
                </li>
                <li class="menu-item <?php echo e(request()->routeIs('admin.currencies') ? 'active' : ''); ?>">
                    <a href="<?php echo e(route('admin.currencies')); ?>" class="menu-link">
                        <i class="icon ion-md-card"></i>
                        <span>Assets</span>
                    </a>
                </li>
            </ul>
        </aside>

        <!-- Main Content -->
        <main class="admin-main">
            <?php echo $__env->yieldContent('content'); ?>
        </main>
    </div>
    

    <?php echo \Livewire\Mechanisms\FrontendAssets\FrontendAssets::scripts(); ?>

    <script src="/assets/js/jquery-3.4.1.min.js"></script>
    <script src="/assets/js/popper.min.js"></script>
    <script src="/assets/js/bootstrap.min.js"></script>
    <script src="/assets/js/amcharts-core.min.js"></script>
    <script src="/assets/js/amcharts.min.js"></script>
    <script src="/assets/js/custom.js"></script>
    <script src="https://s3.tradingview.com/tv.js"></script>
    <script src="https://cdnjs.cloudflare.com/ajax/libs/toastr.js/latest/toastr.min.js"></script>
    <script>
        window.addEventListener('alert', event => {
             toastr[event.detail[0].type](event.detail[0].message, event.detail[0].title ?? '')
             toastr.options = {
                "closeButton": true,
                "progressBar": true,
                "positionClass": "toast-bottom-right",
            }
        });
    </script>
</body>
</html> <?php /**PATH C:\Users\indri\prjct\crypo\resources\views/layouts/admin.blade.php ENDPATH**/ ?>