<div>
<div class="row">
    <div class="col-12">
        <div class="card">
            <div class="card-header">
                <div class="mb-3">
                    <i class="icon ion-md-list-box mr-1"></i>
                    Orders Management
                </div>
                
                <ul class="nav nav-pills card-header-pills">
                    <li class="nav-item mr-5">
                        <div class="input-group" style="width: 250px;">
                            <input type="text" wire:model.live="search" class="form-control float-right" placeholder="Search...">
                            <div class="input-group-append">
                                <button type="submit" class="btn btn-secondary">
                                    <i class="icon ion-md-search"></i>
                                </button>
                            </div>
                        </div>
                    </li>
                    <li class="nav-item mr-3">
                        <select wire:model.live="perPage" class="form-control">
                            <option value="10">10 per page</option>
                            <option value="25">25 per page</option>
                            <option value="50">50 per page</option>
                            <option value="100">100 per page</option>
                        </select>
                    </li>
                </ul>
            </div>
            <div class="card-body table-responsive p-0">
                <table class="table table-hover text-nowrap">
                    <thead>
                        <tr>
                            <th wire:click="sortBy('id')" style="cursor: pointer;">
                                ID
                                <!--[if BLOCK]><![endif]--><?php if($sortField === 'id'): ?>
                                    <i class="fas fa-sort-<?php echo e($sortDirection === 'asc' ? 'up' : 'down'); ?>"></i>
                                <?php endif; ?><!--[if ENDBLOCK]><![endif]-->
                            </th>
                            <th wire:click="sortBy('user_id')" style="cursor: pointer;">
                                User
                                <!--[if BLOCK]><![endif]--><?php if($sortField === 'user_id'): ?>
                                    <i class="fas fa-sort-<?php echo e($sortDirection === 'asc' ? 'up' : 'down'); ?>"></i>
                                <?php endif; ?><!--[if ENDBLOCK]><![endif]-->
                            </th>
                            <th wire:click="sortBy('currency_id')" style="cursor: pointer;">
                                Currency
                                <!--[if BLOCK]><![endif]--><?php if($sortField === 'currency_id'): ?>
                                    <i class="fas fa-sort-<?php echo e($sortDirection === 'asc' ? 'up' : 'down'); ?>"></i>
                                <?php endif; ?><!--[if ENDBLOCK]><![endif]-->
                            </th>
                            <th>Type</th>
                            <th wire:click="sortBy('volume')" style="cursor: pointer;">
                                Volume
                                <!--[if BLOCK]><![endif]--><?php if($sortField === 'volume'): ?>
                                    <i class="fas fa-sort-<?php echo e($sortDirection === 'asc' ? 'up' : 'down'); ?>"></i>
                                <?php endif; ?><!--[if ENDBLOCK]><![endif]-->
                            </th>
                            <th wire:click="sortBy('open_price')" style="cursor: pointer;">
                                Open Price
                                <!--[if BLOCK]><![endif]--><?php if($sortField === 'open_price'): ?>
                                    <i class="fas fa-sort-<?php echo e($sortDirection === 'asc' ? 'up' : 'down'); ?>"></i>
                                <?php endif; ?><!--[if ENDBLOCK]><![endif]-->
                            </th>
                            <th>Current Price</th>
                            <th>Take Profit</th>
                            <th>Stop Loss</th>
                            <th wire:click="sortBy('status')" style="cursor: pointer;">
                                Status
                                <!--[if BLOCK]><![endif]--><?php if($sortField === 'status'): ?>
                                    <i class="fas fa-sort-<?php echo e($sortDirection === 'asc' ? 'up' : 'down'); ?>"></i>
                                <?php endif; ?><!--[if ENDBLOCK]><![endif]-->
                            </th>
                            <th wire:click="sortBy('open_time')" style="cursor: pointer;">
                                Open Time
                                <!--[if BLOCK]><![endif]--><?php if($sortField === 'open_time'): ?>
                                    <i class="fas fa-sort-<?php echo e($sortDirection === 'asc' ? 'up' : 'down'); ?>"></i>
                                <?php endif; ?><!--[if ENDBLOCK]><![endif]-->
                            </th>
                            <th wire:click="sortBy('close_time')" style="cursor: pointer;">
                                Close Time
                                <!--[if BLOCK]><![endif]--><?php if($sortField === 'close_time'): ?>
                                    <i class="fas fa-sort-<?php echo e($sortDirection === 'asc' ? 'up' : 'down'); ?>"></i>
                                <?php endif; ?><!--[if ENDBLOCK]><![endif]-->
                            </th>
                            <th wire:click="sortBy('pl')" style="cursor: pointer;">
                                P/L
                                <!--[if BLOCK]><![endif]--><?php if($sortField === 'pl'): ?>
                                    <i class="fas fa-sort-<?php echo e($sortDirection === 'asc' ? 'up' : 'down'); ?>"></i>
                                <?php endif; ?><!--[if ENDBLOCK]><![endif]-->
                            </th>
                            <th>Actions</th>
                        </tr>
                    </thead>
                    <tbody>
                        <!--[if BLOCK]><![endif]--><?php $__currentLoopData = $orders; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $order): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <tr>
                            <td><?php echo e($order->id); ?></td>
                            <td><?php echo e($order->user->name); ?></td>
                            <td><?php echo e($order->currency->name); ?></td>
                            <td>
                                <span class="badge badge-<?php echo e($order->side === 'buy' ? 'success' : 'danger'); ?>">
                                    <?php echo e(strtoupper($order->side)); ?>

                                </span>
                            </td>
                            <td><?php echo e($order->formatted_volume); ?></td>
                            <td><?php echo e($order->formatted_open_price); ?></td>
                            <td>
                                <!--[if BLOCK]><![endif]--><?php if($order->status == 'open'): ?>
                                    <?php echo e($order->side === 'buy' ? $order->currency->formatted_bid : $order->currency->formatted_ask); ?>

                                <?php else: ?>
                                    <?php echo e($order->formatted_close_price); ?>

                                <?php endif; ?><!--[if ENDBLOCK]><![endif]-->
                            </td>
                            <td><?php echo e($order->take_profit ? $order->formatted_take_profit : '-'); ?></td>
                            <td><?php echo e($order->stop_loss ? $order->formatted_stop_loss : '-'); ?></td>
                            <td>
                                <span class="badge badge-<?php echo e($order->status == 'open' ? 'primary' : 'secondary'); ?>">
                                    <?php echo e($order->status == 'open' ? 'Open' : 'Closed'); ?>

                                </span>
                            </td>
                            <td><?php echo e($order->open_time->format('Y-m-d H:i:s')); ?></td>
                            <td><?php echo e($order->close_time ? $order->close_time->format('Y-m-d H:i:s') : '-'); ?></td>
                            <td class="<?php echo e($order->getPLStatus()); ?>">
                                <?php echo e($order->getFormattedPL()); ?>

                            </td>
                            <td>
                                <button class="btn btn-sm btn-info" wire:click="editOrder(<?php echo e($order->id); ?>)" data-toggle="modal" data-target="#editOrderModal">
                                    <i class="fas fa-edit"></i> Edit
                                </button>
                                <!--[if BLOCK]><![endif]--><?php if($order->status == 'open'): ?>
                                    <button class="btn btn-sm btn-warning" wire:click="closeOrder(<?php echo e($order->id); ?>)" wire:confirm="Are you sure you want to close this order?">
                                        <i class="fas fa-times-circle"></i> Close
                                    </button>
                                <?php endif; ?><!--[if ENDBLOCK]><![endif]-->
                                <button class="btn btn-sm btn-danger" wire:click="deleteOrder(<?php echo e($order->id); ?>)" wire:confirm="Are you sure you want to delete this order?">
                                    <i class="fas fa-trash"></i> Delete
                                </button>
                            </td>
                        </tr>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?><!--[if ENDBLOCK]><![endif]-->
                    </tbody>
                </table>
            </div>

            <div class="card-footer clearfix pagination-container">
                <div class="w-100">
                    <?php echo e($orders->links()); ?>

                </div>
            </div>
        </div>
    </div>
</div>

<!-- Edit Order Modal -->
<div class="modal fade" id="editOrderModal" tabindex="-1" role="dialog" aria-labelledby="editOrderModalLabel" aria-hidden="true" wire:ignore.self>
    <div class="modal-dialog modal-lg" role="document">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title" id="editOrderModalLabel">Edit Order #<?php echo e($editingOrder->id ?? ''); ?></h5>
                <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                    <span aria-hidden="true">&times;</span>
                </button>
            </div>
            <div class="modal-body">
                <!--[if BLOCK]><![endif]--><?php if($editingOrder): ?>
                    <form wire:submit.prevent="updateOrder">
                        <div class="row">
                            <div class="col-md-6">
                                <div class="form-group">
                                    <label>User <span class="text-muted small">(read-only)</span></label>
                                    <input type="text" class="form-control bg-secondary" value="<?php echo e($editingOrder->user->name); ?>" readonly>
                                </div>
                            </div>
                            <div class="col-md-6">
                                <div class="form-group">
                                    <label>Currency <span class="text-muted small">(read-only)</span></label>
                                    <input type="text" class="form-control bg-secondary" value="<?php echo e($editingOrder->currency->name); ?>" readonly>
                                </div>
                            </div>
                        </div>

                        <div class="row">
                            <div class="col-md-6">
                                <div class="form-group">
                                    <label>Type <span class="text-muted small">(read-only)</span></label>
                                    <input type="text" class="form-control bg-secondary" value="<?php echo e(strtoupper($editingOrder->side)); ?>" readonly>
                                </div>
                            </div>
                            <div class="col-md-6">
                                <div class="form-group">
                                    <label>Status <span class="text-muted small">(read-only)</span></label>
                                    <input type="text" class="form-control bg-secondary" value="<?php echo e($editingOrder->status == 'open' ? 'Open' : 'Closed'); ?>" readonly>
                                </div>
                            </div>
                        </div>

                        <div class="row">
                            <div class="col-md-6">
                                <div class="form-group">
                                    <label for="editVolume">Volume</label>
                                    <input type="number" class="form-control" id="editVolume" wire:model="editVolume" step="0.1" min="0.1">
                                </div>
                            </div>
                            <div class="col-md-6">
                                <div class="form-group">
                                    <label for="editFee">Fee</label>
                                    <input type="number" class="form-control" id="editFee" wire:model="editFee" step="0.01" min="0">
                                </div>
                            </div>
                        </div>

                        <div class="row">
                            <div class="col-md-6">
                                <div class="form-group">
                                    <label for="editOpenPrice">Open Price</label>
                                    <input type="number" class="form-control" id="editOpenPrice" wire:model="editOpenPrice" step="0.00001" min="0">
                                </div>
                            </div>
                            <div class="col-md-6">
                                <div class="form-group">
                                    <label for="editOpenTime">Open Time</label>
                                    <input type="datetime-local" class="form-control" id="editOpenTime" wire:model="editOpenTime">
                                </div>
                            </div>
                        </div>

                        <div class="row">
                            <div class="col-md-6">
                                <div class="form-group">
                                    <label for="editTakeProfit">Take Profit</label>
                                    <input type="number" class="form-control" id="editTakeProfit" wire:model="editTakeProfit" step="0.00001" min="0">
                                </div>
                            </div>
                            <div class="col-md-6">
                                <div class="form-group">
                                    <label for="editStopLoss">Stop Loss</label>
                                    <input type="number" class="form-control" id="editStopLoss" wire:model="editStopLoss" step="0.00001" min="0">
                                </div>
                            </div>
                        </div>

                        <!--[if BLOCK]><![endif]--><?php if($editingOrder->status == 'closed'): ?>
                            <div class="row">
                                <div class="col-md-6">
                                    <div class="form-group">
                                        <label for="editClosePrice">Close Price</label>
                                        <input type="number" class="form-control" id="editClosePrice" wire:model="editClosePrice" step="0.00001" min="0">
                                    </div>
                                </div>
                                <div class="col-md-6">
                                    <div class="form-group">
                                        <label for="editCloseTime">Close Time</label>
                                        <input type="datetime-local" class="form-control" id="editCloseTime" wire:model="editCloseTime">
                                    </div>
                                </div>
                            </div>
                        <?php endif; ?><!--[if ENDBLOCK]><![endif]-->

                        <div class="row">
                            <div class="col-md-12">
                                <div class="form-group">
                                    <label>P/L <span class="text-muted small">(read-only)</span></label>
                                    <input type="text" class="form-control bg-secondary <?php echo e($editingOrder->getPLStatus()); ?>" value="<?php echo e($editingOrder->getFormattedPL()); ?>" readonly>
                                </div>
                            </div>
                        </div>
                    </form>
                <?php endif; ?><!--[if ENDBLOCK]><![endif]-->
            </div>
            <div class="modal-footer">
                <button type="button" class="btn btn-secondary" data-dismiss="modal">Close</button>
                <button type="button" class="btn btn-primary" wire:click="updateOrder" data-dismiss="modal">Save changes</button>
            </div>
        </div>
    </div>
</div>

<!--[if BLOCK]><![endif]--><?php if(session()->has('message')): ?>
    <div class="alert alert-success">
        <?php echo e(session('message')); ?>

    </div>
<?php endif; ?><!--[if ENDBLOCK]><![endif]-->
</div><?php /**PATH C:\Users\indri\prjct\webtrader12-01\webtrader\resources\views/livewire/admin-orders.blade.php ENDPATH**/ ?>