<?php

namespace App\Livewire\Profile;

use Livewire\Component;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\Hash;

class Security extends Component
{
    public $current_password;
    public $new_password;
    public $new_password_confirmation;

    protected function rules()
    {
        return [
            'current_password' => 'required|current_password',
            'new_password' => 'required|min:8|confirmed',
            'new_password_confirmation' => 'required',
        ];
    }

    protected $messages = [
        'current_password.current_password' => 'The current password is incorrect.',
        'new_password.min' => 'The new password must be at least 8 characters.',
        'new_password.confirmed' => 'The new password confirmation does not match.',
    ];

    public function save()
    {
        try {
            $this->validate();

            $user = Auth::user();
            $user->update([
                'password' => Hash::make($this->new_password)
            ]);

            $this->reset(['current_password', 'new_password', 'new_password_confirmation']);
            session()->flash('message', 'Password updated successfully.');
        } catch (\Exception $e) {
            session()->flash('error', $e->getMessage());
        }
    }

    public function render()
    {
        return view('livewire.profile.security');
    }
} 