<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Relations\BelongsToMany;

class Role extends Model
{
    protected $fillable = ['name', 'description'];

    public function users(): BelongsToMany
    {
        return $this->belongsToMany(User::class);
    }

    public function hasPermission(string $permission): bool
    {
        return in_array($permission, $this->permissions);
    }

    public function getPermissionsAttribute(): array
    {
        return match($this->name) {
            'admin' => [
                'manage_users',
                'manage_roles',
                'view_dashboard',
                'manage_settings',
                'view_reports',
                'manage_transactions'
            ],
            'user' => [
                'view_dashboard',
                'manage_transactions'
            ],
            default => []
        };
    }
} 