@extends('layouts.admin')

@section('content')
<div class="container-fluid">
    <div class="row">
        <!-- Right: User Info Form -->
        <div class="col-md-4 mb-4">
            <div class="card">
                <div class="card-header d-flex align-items-center justify-content-between">
                    <div>
                        <i class="icon ion-md-map mr-1"></i>
                        Edit User #{{ $user->id }}
                    </div>
                    <div>
                        Status:
                        @if($user->isOnline())
                            <span class="badge badge-success">Online</span>
                        @else
                            <span class="badge badge-secondary">Offline</span>
                        @endif
                    </div>
                </div>
                <div class="card-body">
                    <form method="POST" action="{{ route('admin.users.edit', $user->id) }}">
                        @csrf
                        @method('PUT')
                        <div class="form-group">
                            <label>Name</label>
                            <input type="text" name="name" class="form-control" value="{{ old('name', $user->name) }}" required>
                        </div>
                        <div class="form-group">
                            <label>Email</label>
                            <input type="email" name="email" class="form-control" value="{{ old('email', $user->email) }}" required>
                        </div>
                        <div class="form-group">
                            <label>Login ID</label>
                            <input type="text" name="login" class="form-control" value="{{ old('login', $user->login) }}" required>
                        </div>
                        <div class="form-group">
                            <label>Password</label>
                            <input type="password" name="password" class="form-control" placeholder="Leave blank to keep current password">
                        </div>
                        <div class="form-group">
                            <label>Promo Code</label>
                            <input type="text" name="promo_code" class="form-control" value="{{ old('promo_code', $user->promo_code) }}">
                        </div>
                        
                        <div class="form-group">
                            <label>Phone Number</label>
                            <input type="number" name="phone_number" class="form-control" value="{{ old('phone_number', $user->phone_number) }}">
                        </div>
                        <div class="form-group">
                            <label>Address</label>
                            <input type="text" name="address" class="form-control" value="{{ old('address', $user->address->address ?? '') }}">
                        </div>
                        @if(auth()->user()->hasRole('admin'))
                        <div class="form-group">
                            <label>Roles</label>
                            <select name="roles[]" class="form-control">
                                @foreach($roles as $role)
                                    <option value="{{ $role->id }}" {{ $user->roles->contains($role->id) ? 'selected' : '' }}>{{ $role->name }}</option>
                                @endforeach
                            </select>
                        </div>
                        @if(!$user->hasRole('manager') && !$user->hasRole('admin'))
                        <div class="form-group">
                            <label>Manager</label>
                            <select name="manager_id" class="form-control">
                                <option value="">Select Manager</option>
                                @foreach($managers as $manager)
                                    <option value="{{ $manager->id }}" {{ $user->manager_id == $manager->id ? 'selected' : '' }}>{{ $manager->name }}</option>
                                @endforeach
                            </select>
                        </div>
                        @endif
                        @endif
                        <div class="mt-3">
                            <button type="submit" class="btn btn-success">Save Changes</button>
                            <a href="{{ route('admin.users') }}" class="btn btn-secondary">Back</a>
                            @if($showLoginAsButton)
                            <a href="{{ route('admin.users.login-as', $user->id) }}" class="btn btn-primary">
                                <i class="icon ion-md-log-in mr-1"></i> Login as User
                            </a>
                            @endif
                        </div>
                    </form>
                </div>
            </div>
        </div>
        <!-- Right: Tabs for Sessions and Comments -->
        <div class="col-md-8 mb-4">
            <div class="card">
                <div class="card-body">
                    <ul class="nav nav-tabs" id="userTab" role="tablist">
                        <li class="nav-item">
                            <a class="nav-link active" id="sessions-tab" data-toggle="tab" href="#sessions" role="tab" aria-controls="sessions" aria-selected="true">Recent Sessions</a>
                        </li>
                        <li class="nav-item">
                            <a class="nav-link" id="comments-tab" data-toggle="tab" href="#comments" role="tab" aria-controls="comments" aria-selected="false">Comments</a>
                        </li>
                    </ul>
                    <div class="tab-content mt-3" id="userTabContent">
                        <!-- Sessions Tab -->
                        <div class="tab-pane fade show active" id="sessions" role="tabpanel" aria-labelledby="sessions-tab">
                            <div class="table-responsive">
                                <table class="table table-sm">
                                    <thead>
                                        <tr>
                                            <th>Login At</th>
                                            <th>Logout At</th>
                                            <th>Duration</th>
                                            <th>IP Address</th>
                                        </tr>
                                    </thead>
                                    <tbody>
                                        @foreach($sessions as $session)
                                            <tr>
                                                <td>{{ $session->login_at }}</td>
                                                <td>{{ $session->logout_at ?? '-' }}</td>
                                                <td>
                                                    @if($session->logout_at)
                                                        {{ $session->login_at->diffForHumans($session->logout_at, true) }}
                                                    @else
                                                        {{ now()->diffForHumans($session->login_at, true) }}
                                                    @endif
                                                </td>
                                                <td>{{ $session->ip_address }}</td>
                                            </tr>
                                        @endforeach
                                    </tbody>
                                </table>
                            </div>
                        </div>
                        <!-- Comments Tab -->
                        <div class="tab-pane fade" id="comments" role="tabpanel" aria-labelledby="comments-tab">
                            <form method="POST" action="{{ route('admin.users.comments.add', $user->id) }}" class="mb-3">
                                @csrf
                                <div class="input-group">
                                    <input type="text" name="content" class="form-control" placeholder="Add a comment..." required>
                                    <div class="input-group-append">
                                        <button class="btn btn-primary" type="submit">Add</button>
                                    </div>
                                </div>
                            </form>
                            <ul class="list-group">
                                @foreach($user->comments->sortByDesc('created_at') as $comment)
                                    <li class="list-group-item d-flex justify-content-between align-items-center">
                                        <span>{{ $comment->content }} <span class="text-muted"> ({{ $comment->created_at->diffForHumans() }})</span></span>
                                    </li>
                                @endforeach
                            </ul>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>
@endsection 