<div class="container-fluid px-4">
<div class="row">
    <div class="col-12">
        <div class="card">
            <div class="card-header">
                <div class="mb-3">
                    <i class="icon ion-md-pricetag mr-1"></i>
                    Promo Codes Management
                </div>
                
                <ul class="nav nav-pills card-header-pills">
                    <li class="nav-item mr-5">
                        <div class="input-group" style="width: 250px;">
                            <input type="text" wire:model.live="search" class="form-control float-right" placeholder="Search...">
                            <div class="input-group-append">
                                <button type="submit" class="btn btn-secondary">
                                    <i class="icon ion-md-search"></i>
                                </button>
                            </div>
                        </div>
                    </li>
                    <li class="nav-item">
                        <button type="button" class="btn btn-primary" wire:click.prevent="openAddModal()">Add Promo Code</button>
                    </li>
                </ul>
            </div>
            <div class="card-body table-responsive p-0">
                <table class="table table-hover text-nowrap">
                    <thead>
                        <tr>
                            <th wire:click="sortBy('id')" style="cursor: pointer;">
                                ID
                                @if($sortField === 'id')
                                    <i class="fas fa-sort-{{ $sortDirection === 'asc' ? 'up' : 'down' }}"></i>
                                @endif
                            </th>
                            <th wire:click="sortBy('code')" style="cursor: pointer;">
                                Code
                                @if($sortField === 'code')
                                    <i class="fas fa-sort-{{ $sortDirection === 'asc' ? 'up' : 'down' }}"></i>
                                @endif
                            </th>
                            <th wire:click="sortBy('description')" style="cursor: pointer;">
                                Description
                                @if($sortField === 'description')
                                    <i class="fas fa-sort-{{ $sortDirection === 'asc' ? 'up' : 'down' }}"></i>
                                @endif
                            </th>
                            <th wire:click="sortBy('created_at')" style="cursor: pointer;">
                                Created At
                                @if($sortField === 'created_at')
                                    <i class="fas fa-sort-{{ $sortDirection === 'asc' ? 'up' : 'down' }}"></i>
                                @endif
                            </th>
                            <th>Actions</th>
                        </tr>
                    </thead>
                    <tbody>
                        @forelse($promoCodes as $promoCode)
                        <tr>
                            <td>{{ $promoCode->id }}</td>
                            <td><strong>{{ $promoCode->code }}</strong></td>
                            <td>{{ $promoCode->description }}</td>
                            <td>{{ $promoCode->created_at ? $promoCode->created_at->format('Y-m-d H:i') : 'N/A' }}</td>
                            <td>
                                <button class="btn btn-sm btn-danger" wire:click="confirmDelete({{ $promoCode->id }})">
                                    <i class="fas fa-trash"></i> Delete
                                </button>
                            </td>
                        </tr>
                        @empty
                        <tr>
                            <td colspan="5" class="text-center">No promo codes found</td>
                        </tr>
                        @endforelse
                    </tbody>
                </table>
            </div>
            <div class="card-footer clearfix pagination-container">
                <div class="w-100">
                    {{ $promoCodes->links() }}
                </div>
            </div>
        </div>
    </div>
</div>

<!-- Add Promo Code Modal -->
@if($showAddModal)
<div class="modal fade show" style="display: block;" tabindex="-1" role="dialog">
    <div class="modal-dialog" role="document">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title">Add New Promo Code</h5>
                <button type="button" class="close" wire:click="$set('showAddModal', false)">
                    <span aria-hidden="true">&times;</span>
                </button>
            </div>
            <div class="modal-body">
                <div class="form-group">
                    <label>Code</label>
                    <input type="text" class="form-control" wire:model="code" placeholder="Enter promo code">
                    @error('code') <span class="text-danger">{{ $message }}</span> @enderror
                </div>
                <div class="form-group">
                    <label>Description</label>
                    <textarea class="form-control" wire:model="description" rows="3" placeholder="Enter description"></textarea>
                    @error('description') <span class="text-danger">{{ $message }}</span> @enderror
                </div>
            </div>
            <div class="modal-footer">
                <button type="button" class="btn btn-secondary" wire:click="$set('showAddModal', false)">Cancel</button>
                <button type="button" class="btn btn-primary" wire:click="createPromoCode">Add Promo Code</button>
            </div>
        </div>
    </div>
</div>
<div class="modal-backdrop fade show"></div>
@endif

<!-- Edit Promo Code Modal -->
@if($showEditModal)
<div class="modal fade show" style="display: block;" tabindex="-1" role="dialog">
    <div class="modal-dialog" role="document">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title">Edit Promo Code</h5>
                <button type="button" class="close" wire:click="$set('showEditModal', false)">
                    <span aria-hidden="true">&times;</span>
                </button>
            </div>
            <div class="modal-body">
                <div class="form-group">
                    <label>Code</label>
                    <input type="text" class="form-control" wire:model="code" placeholder="Enter promo code">
                    @error('code') <span class="text-danger">{{ $message }}</span> @enderror
                </div>
                <div class="form-group">
                    <label>Description</label>
                    <textarea class="form-control" wire:model="description" rows="3" placeholder="Enter description"></textarea>
                    @error('description') <span class="text-danger">{{ $message }}</span> @enderror
                </div>
            </div>
            <div class="modal-footer">
                <button type="button" class="btn btn-secondary" wire:click="$set('showEditModal', false)">Cancel</button>
                <button type="button" class="btn btn-primary" wire:click="updatePromoCode">Update Promo Code</button>
            </div>
        </div>
    </div>
</div>
<div class="modal-backdrop fade show"></div>
@endif

<!-- Delete Confirmation Modal -->
@if($showDeleteModal)
<div class="modal fade show" style="display: block;" tabindex="-1" role="dialog">
    <div class="modal-dialog" role="document">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title">Delete Promo Code</h5>
                <button type="button" class="close" wire:click="$set('showDeleteModal', false)">
                    <span aria-hidden="true">&times;</span>
                </button>
            </div>
            <div class="modal-body">
                <p>Are you sure you want to delete this promo code? This action cannot be undone.</p>
            </div>
            <div class="modal-footer">
                <button type="button" class="btn btn-secondary" wire:click="$set('showDeleteModal', false)">Cancel</button>
                <button type="button" class="btn btn-danger" wire:click="deletePromoCode">Delete</button>
            </div>
        </div>
    </div>
</div>
<div class="modal-backdrop fade show"></div>
@endif

@if (session()->has('message'))
    <div class="alert alert-success">
        {{ session('message') }}
    </div>
@endif 
</div>