<div class="card">
    <div class="card-body">
        <h5 class="card-title">Security Settings</h5>
        <div class="settings-profile">
            @if (session()->has('message'))
                <div class="alert alert-success alert-dismissible fade show" role="alert">
                    {{ session('message') }}
                    <button type="button" class="close" data-dismiss="alert" aria-label="Close">
                        <span aria-hidden="true">&times;</span>
                    </button>
                </div>
            @endif

            @if (session()->has('error'))
                <div class="alert alert-danger alert-dismissible fade show" role="alert">
                    {{ session('error') }}
                    <button type="button" class="close" data-dismiss="alert" aria-label="Close">
                        <span aria-hidden="true">&times;</span>
                    </button>
                </div>
            @endif

            <form wire:submit="save">
                <div class="form-row">
                    <div class="col-md-6">
                        <label for="current_password">Current Password</label>
                        <input id="current_password" 
                               type="password" 
                               class="form-control @error('current_password') is-invalid @enderror" 
                               wire:model="current_password">
                        @error('current_password') <span class="text-danger">{{ $message }}</span> @enderror
                    </div>
                    <div class="col-md-6">
                        <label for="new_password">New Password</label>
                        <input id="new_password" 
                               type="password" 
                               class="form-control @error('new_password') is-invalid @enderror" 
                               wire:model="new_password">
                        @error('new_password') <span class="text-danger">{{ $message }}</span> @enderror
                    </div>
                    <div class="col-md-6">
                        <label for="new_password_confirmation">Confirm New Password</label>
                        <input id="new_password_confirmation" 
                               type="password" 
                               class="form-control" 
                               wire:model="new_password_confirmation">
                    </div>
                    <div class="col-md-12">
                        <button type="submit" class="btn btn-primary">Update Password</button>
                    </div>
                </div>
            </form>
        </div>
    </div>
</div> 