<div class="wallet">
    <div class="container-fluid settings">
        <div class="row mt-4">
            <div class="col-md-12 col-lg-6">
                <div class="card wallet">
                    <div class="card-body">
                    <h5 class="card-title">Balances</h5>
                    <ul>
                        <li class="d-flex justify-content-between align-items-center">
                        <div class="d-flex align-items-center">
                            <i class="icon ion-md-cash"></i>
                            <h2>Equity</h2>
                        </div>
                        <div>
                            <h3><?php echo e(number_format(Auth::user()->getFormattedTotalUnrealizedPL() + Auth::user()->confirmedBalance(), 2)); ?> USD</h3>
                        </div>
                        </li>
                        <li class="d-flex justify-content-between align-items-center">
                        <div class="d-flex align-items-center">
                            <i class="icon ion-md-checkmark"></i>
                            <h2>Free Margin</h2>
                        </div>
                        <div>
                            <h3><?php echo e(Auth::user()->getFormattedFreeMargin()); ?> USD</h3>
                        </div>
                        </li>
                    </ul>
                    <button wire:click="openDepositModal" class="btn green">Deposit</button>
                    <button wire:click="openWithdrawModal" class="btn red">Withdraw</button>
                    

                    <!--[if BLOCK]><![endif]--><?php if(session()->has('message')): ?>
                        <div class="alert alert-success alert-dismissible fade show" role="alert">
                            <?php echo e(session('message')); ?>

                            <button type="button" class="close" data-dismiss="alert" aria-label="Close">
                                <span aria-hidden="true">&times;</span>
                            </button>
                        </div>
                    <?php endif; ?><!--[if ENDBLOCK]><![endif]-->

                    <?php if(session()->has('error')): ?>
                        <div class="alert alert-danger alert-dismissible fade show" role="alert">
                            <?php echo e(session('error')); ?>

                            <button type="button" class="close" data-dismiss="alert" aria-label="Close">
                                <span aria-hidden="true">&times;</span>
                            </button>
                        </div>
                    <?php endif; ?><!--[if ENDBLOCK]><![endif]-->
                    </div>
                    
                </div>
            </div>
            
            <div class="col-md-12 col-lg-6">
                <div class="card">
                    <div class="card-body">
                        <h5 class="card-title">Wallet Deposit Address</h5>
                        <div class="row wallet-address">
                            <div class="col-md-8">
                            <p>Deposits to this address are unlimited.</p>
                            <div class="input-group">
                                <input type="text" class="form-control" value="<?php echo e(Auth::user()->getWalletAddress()); ?>">
                                <div class="input-group-prepend">
                                    <button class="btn btn-primary" onclick="copyToClipboard('<?php echo e(Auth::user()->getWalletAddress()); ?>')">COPY</button>
                                </div>
                            </div>
                            </div>
                            <div class="col-md-4">
                                <div class="qr-code-container" wire:ignore>
                                    <!--[if BLOCK]><![endif]--><?php if(Auth::user()->getWalletAddress()): ?>
                                        <?php echo DNS2D::getBarcodeHTML(Auth::user()->getWalletAddress(), 'QRCODE', 10,10,'white'); ?>

                                    <?php else: ?>
                                        <p>No wallet address found</p>
                                    <?php endif; ?><!--[if ENDBLOCK]><![endif]-->
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
        <div class="row">
            <div class="col-md-12 col-lg-12">
                <div class="card">
                    <div class="card-body">
                    <h5 class="card-title mt-4">Recent Transactions</h5>
                        <div class="table-responsive">
                            
                            <table class="table">
                                <thead>
                                    <tr>
                                        <th>Date</th>
                                        <th>Type</th>
                                        <th>Amount</th>
                                        <th>To Address</th>
                                        <th>Status</th>
                                    </tr>
                                </thead>
                                <tbody>
                                    <!--[if BLOCK]><![endif]--><?php $__empty_1 = true; $__currentLoopData = $transactions; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $transaction): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                                        <tr>
                                            <td><?php echo e($transaction->created_at ? $transaction->created_at->format('Y-m-d H:i') : '-'); ?></td>
                                            <td>
                                                <span class="badge badge-<?php echo e($transaction->type === 'deposit' ? 'success' : 'warning'); ?>">
                                                    <?php echo e(ucfirst($transaction->type)); ?>

                                                </span>
                                            </td>
                                            <td><?php echo e(number_format($transaction->amount, 2)); ?> USD</td>
                                            <td><?php echo e($transaction->to_address); ?></td>
                                            <td>
                                                <!--[if BLOCK]><![endif]--><?php if($transaction->confirmed == 1): ?>
                                                    <i class="icon ion-md-checkmark-circle-outline green"></i>
                                                <?php else: ?>
                                                    <i class="icon ion-md-close-circle-outline red"></i>
                                                <?php endif; ?><!--[if ENDBLOCK]><![endif]-->
                                            </td>
                                        </tr>
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                                        <tr>
                                            <td colspan="5 class="text-center">No transactions found</td>
                                        </tr>
                                    <?php endif; ?><!--[if ENDBLOCK]><![endif]-->
                                </tbody>
                            </table>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <!-- Deposit Modal -->
    <!--[if BLOCK]><![endif]--><?php if($showDepositModal): ?>
    <div class="modal fade show" style="display: block;" tabindex="-1" role="dialog">
        <div class="modal-dialog" role="document">
            <div class="modal-content">
                <div class="modal-header">
                    <h5 class="modal-title">Initiate Deposit</h5>
                    <button type="button" class="close" wire:click="closeModal">
                        <span aria-hidden="true">&times;</span>
                    </button>
                </div>
                <div class="modal-body">
                    <form wire:submit="initiateDeposit">
                        <div class="form-group">
                            <label>Amount</label>
                            <input type="number" step="0.01" class="form-control" wire:model="amount">
                            <!--[if BLOCK]><![endif]--><?php $__errorArgs = ['amount'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> <span class="text-danger"><?php echo e($message); ?></span> <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?><!--[if ENDBLOCK]><![endif]-->
                        </div>
                        <div class="modal-footer">
                            <button type="button" class="btn btn-secondary" wire:click="closeModal">Cancel</button>
                            <button type="submit" class="btn btn-primary">Continue</button>
                        </div>
                    </form>
                </div>
            </div>
        </div>
    </div>
    <div class="modal-backdrop fade show"></div>
    <?php endif; ?><!--[if ENDBLOCK]><![endif]-->

    <!-- Deposit Address Modal -->
    <!--[if BLOCK]><![endif]--><?php if($showDepositAddressModal): ?>
    <div class="modal fade show" style="display: block;" tabindex="-1" role="dialog">
        <div class="modal-dialog" role="document">
            <div class="modal-content">
            <div class="modal-header">
                    <h5 class="modal-title">Wallet Deposit Address</h5>
                    <button type="button" class="close" wire:click="closeModal">
                        <span aria-hidden="true">&times;</span>
                    </button>
                </div>
                <div class="modal-body">
                    <div class="row wallet-address">
                        
                        <div class="col-md-12">
                            <div class="qr-code-container-modal">
                                <!--[if BLOCK]><![endif]--><?php if(Auth::user()->getWalletAddress()): ?>
                                    <?php echo DNS2D::getBarcodeHTML(Auth::user()->getWalletAddress(), 'QRCODE', 10,10,'white'); ?>

                                <?php else: ?>
                                    <p>No wallet address found</p>
                                <?php endif; ?><!--[if ENDBLOCK]><![endif]-->
                            </div>
                        </div>
                        <div class="col-md-12">
                            <div class="input-group">
                                <input type="text" class="form-control" value="<?php echo e(Auth::user()->getWalletAddress()); ?>" readonly>
                                <div class="input-group-prepend">
                                    <button class="btn btn-primary" onclick="copyToClipboard('<?php echo e(Auth::user()->getWalletAddress()); ?>')">COPY</button>
                                </div>
                            </div>
                        </div>
                    </div>
                    <div class="mt-4">
                        <div class="alert alert-info">
                            <i class="icon ion-md-information-circle-outline"></i>
                            Please send exactly <?php echo e(number_format($amount, 2)); ?> to the address above.
                        </div>
                    </div>
                </div>
                <div class="modal-footer">
                    <button type="button" class="btn btn-secondary" wire:click="closeModal">Close</button>
                </div>
            </div>
        </div>
    </div>
    <div class="modal-backdrop fade show"></div>
    <?php endif; ?><!--[if ENDBLOCK]><![endif]-->

    <script>
        function copyToClipboard(text) {
            navigator.clipboard.writeText(text).then(function() {
                alert('Address copied to clipboard!');
            }, function(err) {
                console.error('Could not copy text: ', err);
            });
        }
    </script>

    <!-- Withdraw Modal -->
    <!--[if BLOCK]><![endif]--><?php if($showWithdrawModal): ?>
    <div class="modal fade show" style="display: block;" tabindex="-1" role="dialog">
        <div class="modal-dialog" role="document">
            <div class="modal-content">
                <div class="modal-header">
                    <h5 class="modal-title">Withdraw Funds</h5>
                    <button type="button" class="close" wire:click="closeModal">
                        <span aria-hidden="true">&times;</span>
                    </button>
                </div>
                <div class="modal-body">
                    <form wire:submit="withdraw">
                        <div class="alert alert-info mb-3">
                            <i class="icon ion-md-information-circle-outline"></i>
                            Maximum withdrawable amount: <?php echo e(Auth::user()->confirmedBalance()); ?> USD
                        </div>
                        <div class="form-group">
                            <label>Amount</label>
                            <input type="number" step="0.00000001" class="form-control <?php $__errorArgs = ['amount'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>" wire:model.live="amount">
                            <!--[if BLOCK]><![endif]--><?php $__errorArgs = ['amount'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> 
                                <span class="text-danger"><?php echo e($message); ?></span>
                            <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?><!--[if ENDBLOCK]><![endif]-->
                            <!--[if BLOCK]><![endif]--><?php if($amount && !$canWithdraw): ?>
                                <span class="text-danger">Amount exceeds your available balance</span>
                            <?php endif; ?><!--[if ENDBLOCK]><![endif]-->
                        </div>
                        <div class="form-group">
                            <label>To Address</label>
                            <input type="text" class="form-control <?php $__errorArgs = ['toAddress'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>" wire:model="toAddress" placeholder="Enter the destination wallet address">
                            <!--[if BLOCK]><![endif]--><?php $__errorArgs = ['toAddress'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> 
                                <span class="text-danger"><?php echo e($message); ?></span>
                            <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?><!--[if ENDBLOCK]><![endif]-->
                        </div>
                        <div class="modal-footer">
                            <button type="button" class="btn btn-secondary" wire:click="closeModal">Cancel</button>
                            <button type="submit" class="btn btn-primary" <?php if(!$canWithdraw): ?> disabled <?php endif; ?>>Withdraw</button>
                        </div>
                    </form>
                </div>
            </div>
        </div>
    </div>
    <div class="modal-backdrop fade show"></div>
    <?php endif; ?><!--[if ENDBLOCK]><![endif]-->
</div> <?php /**PATH C:\Users\indri\prjct\crypo\resources\views/livewire/wallet.blade.php ENDPATH**/ ?>