<div class="container-fluid">
    <div class="row">
        <div class="col-12">
            <div class="card">
                <div class="card-header">
                <div class="mb-3">
                        <i class="icon ion-md-people mr-1"></i>
                        Users Management
                    </div>
                    <div class="card-tools">
                        <div class="input-group input-group-sm" style="width: 250px;">
                            <input type="text" 
                                   class="form-control float-right" 
                                   placeholder="Search" 
                                   wire:model.live.debounce.300ms="search">
                            <div class="input-group-append">
                                <button type="button" class="btn btn-secondary">
                                    <i class="icon ion-md-search"></i>
                                </button>
                            </div>
                        </div>
                    </div>
                </div>
                <div class="card-body table-responsive p-0">
                    <table class="table table-hover text-nowrap">
                        <thead>
                            <tr>
                                <th wire:click="sortBy('id')" style="cursor: pointer;">
                                    ID
                                    <!--[if BLOCK]><![endif]--><?php if($sortField === 'id'): ?>
                                        <i class="fas fa-sort-<?php echo e($sortDirection === 'asc' ? 'up' : 'down'); ?>"></i>
                                    <?php endif; ?><!--[if ENDBLOCK]><![endif]-->
                                </th>
                                <th wire:click="sortBy('name')" style="cursor: pointer;">
                                    Name
                                    <!--[if BLOCK]><![endif]--><?php if($sortField === 'name'): ?>
                                        <i class="fas fa-sort-<?php echo e($sortDirection === 'asc' ? 'up' : 'down'); ?>"></i>
                                    <?php endif; ?><!--[if ENDBLOCK]><![endif]-->
                                </th>
                                <th wire:click="sortBy('email')" style="cursor: pointer;">
                                    Email
                                    <!--[if BLOCK]><![endif]--><?php if($sortField === 'email'): ?>
                                        <i class="fas fa-sort-<?php echo e($sortDirection === 'asc' ? 'up' : 'down'); ?>"></i>
                                    <?php endif; ?><!--[if ENDBLOCK]><![endif]-->
                                </th>
                                <th>Manager</th>
                                <th>Balance</th>
                                <th>Role</th>
                                <th>Actions</th>
                            </tr>
                        </thead>
                        <tbody>
                            <!--[if BLOCK]><![endif]--><?php $__currentLoopData = $users; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $user): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <tr>
                                <td><?php echo e($user->id); ?></td>
                                <td><?php echo e($user->name); ?></td>
                                <td><?php echo e($user->email); ?></td>
                                <td><?php echo e($user->manager->name ?? 'N/A'); ?></td>
                                <td><?php echo e($user->confirmedBalance()); ?> USD</td>
                                <td>
                                    <!--[if BLOCK]><![endif]--><?php $__currentLoopData = $user->roles; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $role): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                        <span class="badge badge-primary"><?php echo e($role->name); ?></span>
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?><!--[if ENDBLOCK]><![endif]-->
                                </td>
                                <td>
                                    <button class="btn btn-sm btn-info" wire:click="editUser(<?php echo e($user->id); ?>)">
                                        <i class="fas fa-edit"></i> Edit
                                    </button>
                                    
                                    <!--[if BLOCK]><![endif]--><?php if(Auth::user()->hasRole('admin')): ?>
                                    <button class="btn btn-sm btn-danger" wire:click="confirmDelete(<?php echo e($user->id); ?>)">
                                        <i class="fas fa-trash"></i> Delete
                                    </button>
                                    <?php endif; ?><!--[if ENDBLOCK]><![endif]-->
                                </td>
                            </tr>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?><!--[if ENDBLOCK]><![endif]-->
                        </tbody>
                    </table>
                </div>
                <div class="card-footer clearfix pagination-container">
                    <div class="w-100">
                        <?php echo e($users->links()); ?>

                    </div>
                </div>
            </div>
        </div>
    </div>

    <!-- Delete User Modal -->
    <!--[if BLOCK]><![endif]--><?php if($showDeleteModal): ?>
    <div class="modal fade show" style="display: block;" tabindex="-1" role="dialog">
        <div class="modal-dialog" role="document">
            <div class="modal-content">
                <div class="modal-header">
                    <h5 class="modal-title">Delete User</h5>
                    <button type="button" class="close" wire:click="closeModal">
                        <span aria-hidden="true">&times;</span>
                    </button>
                </div>
                <div class="modal-body">
                    <p>Are you sure you want to delete user "<?php echo e($deletingUser->name); ?>"? This action cannot be undone.</p>
                </div>
                <div class="modal-footer">
                    <button type="button" class="btn btn-secondary" wire:click="closeModal">Cancel</button>
                    <button type="button" class="btn btn-danger" wire:click="deleteUser">Delete</button>
                </div>
            </div>
        </div>
    </div>
    <div class="modal-backdrop fade show"></div>
    <?php endif; ?><!--[if ENDBLOCK]><![endif]-->

<!--[if BLOCK]><![endif]--><?php if(session()->has('message')): ?>
    <div class="alert alert-info">
        <?php echo e(session('message')); ?>

    </div>
<?php endif; ?><!--[if ENDBLOCK]><![endif]--> 

</div><?php /**PATH /home/viktorion/public_html/webtrader/resources/views/livewire/admin-users.blade.php ENDPATH**/ ?>